<?php
/**
  * @author     Apaczka.pl <bok@apaczka.pl>
  * @copyright  Apaczka.pl
  * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
  * @category   Module
  * @package    Presta 1.7
  * @subpackage ApaczkaShipping
  * @link       https://www.apaczka.pl
  * @since      1.0.0
  * @theme_key  330670a5d241bfe6794d0535db3999b4
  */
  
date_default_timezone_set('Europe/Warsaw');

class apaczkaApi
{

//    Configuration
    public $apiKey = "";
    public $login = "";
    public $password = "";

    public $url_test = "http://test.apaczka.pl/webservice/order";
    public $url_prod = "https://www.apaczka.pl/webservice/order";

    public $wsdl_test = "http://test.apaczka.pl/webservice/order?wsdl";
    public $wsdl_prod = "https://www.apaczka.pl/webservice/order?wsdl";

    public $outputFileName = "XOLTResult.log";


    public $soapError = "";

    private $mode = array('trace' => 1, 'exceptions' => 0, 'encoding' => 'UTF-8');
    protected $client;

    private $isTest = 0;
    private $isVerboseMode = 0;

    public function __construct($login = '', $passwd = '', $apiKey = '')
    {
        if ($login != '' && $passwd != '' && $apiKey != '') {
            $this->apiKey = $apiKey;
            $this->login = $login;
            $this->password = $passwd;
        }
        $this->init();
    }

    public function init()
    {
        if ($this->isTest) {
            $this->client = new SoapClient($this->wsdl_test, $this->mode);
            $this->client->__setLocation($this->url_test);
        } else {
            $this->client = new SoapClient($this->wsdl_prod, $this->mode);
            $this->client->__setLocation($this->url_prod);
        }
    }

    public function placeOrder(apaczkaOrder $order)
    {
        $PlaceOrderRequest = array();
        $PlaceOrderRequest['authorization'] = $this->bindAuthorization();
        $PlaceOrderRequest['order'] = $order->getOrder();

        $resp = $this->soapCall("placeOrder", array('placeOrder' => array('PlaceOrderRequest' => $PlaceOrderRequest)));

        return $resp;
    }

    public function validateAuthData()
    {
        $validateAuthData = array();
        $validateAuthData['validateAuthData']['Authorization'] = $this->bindAuthorization();

        $resp = $this->soapCall("validateAuthData", $validateAuthData);

        return $resp;
    }
    public function getCountries()
    {
        $getCountriesData = array();
        $getCountriesData['getCountries']['CountryRequest']['authorization'] = $this->bindAuthorization();
        $resp = $this->soapCall("getCountries", $getCountriesData);
        return $resp;
    }
    public function getCollectiveWaybillDocument($idsArray = false)
    {
        $req = array();
        $req['authorization'] = $this->bindAuthorization();
        $req['orderIds']= array();
        if ($idsArray) {
            if (is_array($idsArray)) {
                $req['orderIds'] = array('long' => $idsArray);
            } else {
                $req['orderIds'] = array('long' => $idsArray);
            }
        }
        $getCollectiveWaybillDocumentData = array();
        $getCollectiveWaybillDocumentData['getCollectiveWaybillDocument']['CollectiveWaybillRequest'] = $req;
        $resp = $this->soapCall("getCollectiveWaybillDocument", $getCollectiveWaybillDocumentData);
        return $resp;
    }

    public function getWaybillDocument($orderId = false)
    {

        if (!is_numeric($orderId) || !(int)$orderId > 0) {
            throw new Exception('orderId must be intval: [' . print_r($orderId, 1) . '] given.');
        }
        $req = array();
        $req['authorization'] = $this->bindAuthorization();
        $req['orderId'] = $orderId;
        $getWaybillDocumentData = array();
        $getWaybillDocumentData['getWaybillDocument']['WaybillRequest'] = $req;
        $resp = $this->soapCall("getWaybillDocument", $getWaybillDocumentData);
        return $resp;
    }
    public function getCollectiveTurnInCopyDocument($idsArray = false)
    {
        $req = array();
        $req['authorization'] = $this->bindAuthorization();
        $req['orderIds'] = array();
        if ($idsArray) {
            if (is_array($idsArray)) {
                $req['orderIds'] = array('long' => $idsArray);
            } else {
                $req['orderIds'] = array('long' => $idsArray);
            }
        }
        $getCollectiveTurnInCopyDocumentData = array();
        $getCollectiveTurnInCopyDocumentData['getCollectiveTurnInCopyDocument']['CollectiveTurnInCopyRequest'] = $req;
        $resp = $this->soapCall("getCollectiveTurnInCopyDocument", $getCollectiveTurnInCopyDocumentData);
        return $resp;
    }
    public function soapCall($operation, $SoapBody)
    {
        if (!in_array($operation, array("placeOrder", "validateAuthData", "getCountries", "getCollectiveWaybillDocument", "getWaybillDocument", "getCollectiveTurnInCopyDocument"))) {
            throw new Exception('Unsupported operation: [' . $operation . ']');
        }

        try {
            $resp = $this->client->__soapCall($operation, $SoapBody);
            //save soap request and response to file
            
	        //file_put_contents($this->outputFileName, "[" . date('c') . "]\n" . "SoapCall: [$operation]\n", FILE_APPEND);
            //file_put_contents($this->outputFileName, "Request: \n" . $this->client->__getLastRequest() . "\n", FILE_APPEND);
            //file_put_contents($this->outputFileName, "Response: \n" . $this->client->__getLastResponse() . "\n\n", FILE_APPEND);
        } catch (Exception $ex) {
            if ($this->isVerboseMode) {
                print_r($ex);
            }
            //file_put_contents($this->outputFileName, "[" . date('c') . "]\n" . "SoapCall: [$operation]\n", FILE_APPEND);
            //file_put_contents($this->outputFileName, "Request: \n" . $this->client->__getLastRequest() . "\n", FILE_APPEND);
            //file_put_contents($this->outputFileName, "Response: \n" . $this->client->__getLastResponse() . "\n\n", FILE_APPEND);
            $this->soapError = $ex->getMessage();
            return false;
        }
        if ($this->isVerboseMode) {
            echo("\n\n");
            print_r($this->client->__getLastRequest());
            echo("\n\n");
            print_r($this->client->__getLastResponse());
            echo("\n\n");
        }
        return $resp;
    }
    public function bindAuthorization()
    {
        $auth = array();
        $auth['apiKey'] = $this->apiKey;
        $auth['login'] = $this->login;
        $auth['password'] = $this->password;
        return $auth;
    }
    public function setVerboseMode()
    {
        $this->isVerboseMode = true;
    }
    public function setTestMode()
    {
        $this->isTest = true;
        $this->init();
    }
    public function setProductionMode()
    {
        $this->isTest = false;
        $this->init();
    }
}
class apaczkaOrder
{
    public $notificationDelivered = array();
    public $notificationException = array();
    public $notificationNew = array();
    public $notificationSent = array();
    // cash on delivery
    public $accountNumber = "";
    public $codAmount = "";
    public $orderPickupType = "SELF";
    public $pickupTimeFrom = "";
    public $pickupTimeTo = "";
    public $pickupDate = "";
    public $options = "";
    private $address_receiver = array();
    private $address_sender = array();
    public $referenceNumber = '';
    public $serviceCode = "";
    public $isDomestic = "true";
    public $contents = "";
    public $shipments = array();
    private static $dictServiceCode = array('UPS_Z_STANDARD','UPS_K_STANDARD', 'UPS_K_EX_SAV','UPS_Z_EX_SAV','DPD_CLASSIC', 'DHLSTD','DPD_CLASSIC_FOREIGN', 'TNT_Z' ,'POCZTA_POLSKA_E24', 'DHL12', 'KEX_EXPRESS', 'FEDEX', 'INPOST');
    private static $dictOrderPickupType = array('COURIER', 'SELF', 'EVERYDAY', 'PHONE');
    private static $dictOrderOptions = array('POBRANIE', 'ZWROT_DOK', 'DOR_OSOBA_PRYW', 'DOST_SOB', 'PODPIS_DOROS');
    public function __construct()
    {
        $this->notificationDelivered = $this->emptyNotification();
        $this->notificationException = $this->emptyNotification();
        $this->notificationNew = $this->emptyNotification();
        $this->notificationSent = $this->emptyNotification();
    }
    public function setPobranie($accountNumber, $codAmount)
    {
        $this->accountNumber = $accountNumber;
        $this->codAmount = $codAmount;
        $this->addOrderOption('POBRANIE');
    }
    public function createNotification($isReceiverEmail, $isReceiverSms, $isSenderEmail, $isSenderSms)
    {
        $notification = array();
        $notification['isReceiverEmail'] = $isReceiverEmail;
        $notification['isReceiverSms'] = $isReceiverSms;
        $notification['isSenderEmail'] = $isSenderEmail;
        $notification['isSenderSms'] = $isSenderSms;
        return $notification;
    }
    public function emptyNotification()
    {
        $notification = array();
        $notification['isReceiverEmail'] = '';
        $notification['isReceiverSms'] = '';
        $notification['isSenderEmail'] = '';
        $notification['isSenderSms'] = '';
        return $notification;
    }
    public function setPickup($orderPickupType, $pickupTimeFrom, $pickupTimeTo, $pickupDate)
    {
        if (!in_array($orderPickupType, self::$dictOrderPickupType)) {
            throw new Exception('UNSUPPORTED order pickup type: [' . $orderPickupType . '] must be one of: ' . print_r(self::$dictOrderPickupType, 1));
        }
        $this->orderPickupType = $orderPickupType;
        if ($orderPickupType=='COURIER') {
                        $this->pickupTimeFrom = $pickupTimeFrom;
                        $this->pickupDate = $pickupDate;
                        $this->pickupTimeTo = $pickupTimeTo;
        }
    }
    public function setServiceCode($serviceCode)
    {
        if (!in_array($serviceCode, self::$dictServiceCode)) {
            throw new Exception('UNSUPPORTED service code: [' . $serviceCode . '] must be one of: ' . print_r(self::$dictServiceCode, 1));
        }
        $this->serviceCode = $serviceCode;
    }
    public function addOrderOption($option)
    {
        if (!in_array($option, self::$dictOrderOptions)) {
            throw new Exception('UNSUPPORTED order option: [' . $option . '] must be one of: ' . print_r(self::$dictOrderOptions, 1));
        }
        if ($this->options == "") {
            $this->options = array('string' => $option);
        } else if (!is_array($this->options['string'])) {
            $tmp_option = $this->options['string'];
            if ($tmp_option != $option) {
                $this->options['string'] = array($tmp_option, $option);
            }
        } else {
            if (in_array($option, self::$dictOrderOptions)) {
                $this->options['string'][] = $option;
            }
        }
    }
    public function setReceiverAddress($name = '', $contactName = '', $addressLine1 = '', $addressLine2 = '', $city = '', $countryId = '', $postalCode = '', $stateCode = '', $email = '', $phone = '')
    {
        $this->address_receiver = $this->createAddress($name, $contactName, $addressLine1, $addressLine2, $city, $countryId, $postalCode, $stateCode, $email, $phone);
    }
    public function setSenderAddress($name = '', $contactName = '', $addressLine1 = '', $addressLine2 = '', $city = '', $countryId = '', $postalCode = '', $stateCode = '', $email = '', $phone = '')
    {
        $this->address_sender = $this->createAddress($name, $contactName, $addressLine1, $addressLine2, $city, $countryId, $postalCode, $stateCode, $email, $phone);
    }
    public function createAddress($name = '', $contactName = '', $addressLine1 = '', $addressLine2 = '', $city = '', $countryId = '', $postalCode = '', $stateCode = '', $email = '', $phone = '')
    {
        $address = array();
        $address['name'] = Tools::substr($name, 0, 50);
        $address['contactName'] = $contactName;
        $address['addressLine1'] = $addressLine1;
        $address['addressLine2'] = $addressLine2;
        $address['city'] = $city;
        $address['countryId'] = $countryId;
        $address['postalCode'] = $postalCode;
        if ($stateCode != '') {
            $address['stateCode'] = $stateCode;
        }
        $address['email'] = $email;
        $address['phone'] = $phone;
        return $address;
    }
    public function addShipment(apaczkaOrderShipment $shipment)
    {
        $this->shipments[] = $shipment;
        return;
        if ($this->shipments == "") {
            $this->shipments[] = $shipment;
        } else if (is_array($this->shipments) && count($this->shipments) == 1) {
            $tmp = $this->shipments;
            $this->shipments = array();
            $this->shipments[] = $tmp;
            $this->shipments[] = $shipment;
        } else {
            $this->shipments[] = $shipment;
        }
    }
    public function createShipment()
    {
        $return = array();
        $position = 0;
        $t_tmp = $this->shipments;
        if (!is_array($t_tmp)) {
            $t_tmp = array($t_tmp);
        }
        foreach ($t_tmp as $a) {
            $ship = array();
            $ship['dimension1'] = $a->dimension1;
            $ship['dimension2'] = $a->dimension2;
            $ship['dimension3'] = $a->dimension3;
            $ship['weight'] = $a->weight;
            $ship['shipmentTypeCode'] = $a->getShipmentTypeCode();
            $ship['position'] = $position;
            if ($a->getShipmentValue() > 0) {
                $ship['shipmentValue'] = $a->getShipmentValue();
            }
            $ship['options'] = $a->getOptions();
            $return[] = $ship;
            $position++;
        }
        if ($position === 1) {
            return array('Shipment' => $ship);
        }
        return array('Shipment' => $return);
    }
    public function getOrder()
    {
        $order = array();
        if (!($this->accountNumber == "" || $this->codAmount == "")) {
            $order['accountNumber'] = $this->accountNumber;
            $order['codAmount'] = $this->codAmount;
        }
        $order['notificationDelivered'] = $this->notificationDelivered;
        $order['notificationException'] = $this->notificationException;
        $order['notificationNew'] = $this->notificationNew;
        $order['notificationSent'] = $this->notificationSent;
        $order['orderPickupType'] = $this->orderPickupType;
        if ($this->pickupTimeFrom != '' and $this->pickupTimeTo != '') {
            $order['pickupTimeFrom'] = $this->pickupTimeFrom;
            $order['pickupTimeTo'] = $this->pickupTimeTo;
            $order['pickupDate'] = $this->pickupDate;
        }
        $order['options'] = $this->options;
        $order['serviceCode'] = $this->serviceCode;
        $order['referenceNumber'] = $this->referenceNumber;
        $order['isDomestic'] = $this->isDomestic;
        $order['contents'] = $this->contents;
        $order['receiver'] = $this->address_receiver;
        $order['sender'] = $this->address_sender;
        $order['shipments'] = $this->createShipment();
        return $order;
    }
}
class apaczkaOrderShipment
{
    public $dimension1 = '';
    public $dimension2 = '';
    public $dimension3 = '';
    public $weight = '';
    private $shipmentTypeCode = '';
    private $shipmentValue = '';
    private $options = '';
    private $position = 0;
    private static $dictShipmentOptions = array('UBEZP', 'PRZES_NIETYP', 'DUZA_PACZKA');
    private static $dictShipmentTypeCode = array('LIST', 'PACZ', 'PALETA');
    public function __construct($shipmentTypeCode = '', $dim1 = '', $dim2 = '', $dim3 = '', $weight = '')
    {
        if ($shipmentTypeCode == 'LIST') {
            $this->createShipment($shipmentTypeCode, 0, 0, 0, 0);
        } else {
            if ($dim1 != '' && $dim2 != '' && $dim3 != '' && $weight != '' && $shipmentTypeCode != '') {
                $this->createShipment($shipmentTypeCode, $dim1, $dim2, $dim3, $weight);
            }
        }
    }
    public function getShipmentTypeCode()
    {
        return $this->shipmentTypeCode;
    }
    public function setShipmentTypeCode($shipmentTypeCode)
    {
        if (!in_array($shipmentTypeCode, self::$dictShipmentTypeCode)) {
            throw new Exception('UNSUPPORTED service code: [' . $shipmentTypeCode . '] must be one of: ' . print_r(self::$dictShipmentTypeCode, 1));
        }
        $this->shipmentTypeCode = $shipmentTypeCode;
    }
    public function getOptions()
    {
        return $this->options;
    }
    public function addOrderOption($option)
    {
        if (!in_array($option, self::$dictShipmentOptions)) {
            throw new Exception('UNSUPPORTED order option: [' . $option . '] must be one of: ' . print_r(self::$dictShipmentOptions, 1));
        }
        if ($this->options == "") {
            $this->options = array('string' => $option);
        } else if (!is_array($this->options['string'])) {
            $tmp_option = $this->options['string'];
            if ($tmp_option != $option) {
                $this->options['string'] = array($tmp_option, $option);
            }
        } else {
            $this->options['string'][] = $option;
        }
    }
    public function getShipmentValue()
    {
        return $this->shipmentValue;
    }

    public function setShipmentValue($value)
    {
        if (!$value > 0) {
            throw new Exception('UNSUPPORTED ShipmentValue: [' . $value . '] ShipmentValue must be greater then 0');
        }
        $this->shipmentValue = $value;
        $this->addOrderOption('UBEZP');
    }
    public function createShipment($shipmentTypeCode, $dim1 = '', $dim2 = '', $dim3 = '', $weight = '')
    {
        $this->setShipmentTypeCode($shipmentTypeCode);
        $this->dimension1 = $dim1;
        $this->dimension2 = $dim2;
        $this->dimension3 = $dim3;
        $this->weight = $weight;
    }
}
