<?php
/**
  * @author     Apaczka.pl <bok@apaczka.pl>
  * @copyright  Apaczka.pl
  * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
  * @category   Module
  * @package    Presta 1.7
  * @subpackage ApaczkaShipping
  * @link       https://www.apaczka.pl
  * @since      1.0.0
  * @theme_key  330670a5d241bfe6794d0535db3999b4
  */
  
$fields_form = array();
$fields_form[0]['form'] = array(
    'legend' => array(
        'title' => $this->l('Settings of connection with apaczka.pl'),
        'image' => "../modules/apaczkashipping/views/img/logoMed.png"
    ),
    'input' => array(
        array(
            'type' => 'text',
            'label' => $this->l('User name API'),
            'name' => 'ApaczkaNameAPI',
            'size' => 20,
            'required' => true
        ),
        array(
            'type' => 'text',
            'label' => $this->l('Password API'),
            'name' => 'ApaczkaPasswordAPI',
            'size' => 20,
            'required' => true
        ),
        array(
            'type' => 'text',
            'label' => $this->l('API key'),
            'name' => 'ApaczkaKeyAPI',
            'size' => 20,
            'required' => true
        )
/* ,array(
            'type' => 'radio',
            'label' => $this->l('Use sand box'),
            'name' => 'ApaczkaIsTest',
            'is_bool' => true,
            'class' => 'radio-inline',
            'values' => array(
                array(
                    'id' => 'active_on',
                    'value' => 1,
                    'label' => $this->l('Tak')
                ),
                array(
                    'id' => 'active_off',
                    'value' => 0,
                    'label' => $this->l('Nie')
                )
            )
        )*/
    ),
    'submit' => array(
        'title' => $this->l('Save'),
        'class' => 'button'
    )
);

//*************************************************************************
$fields_form[1]['form'] = array(
    'legend' => array(
        'title' => $this->l('Shipping methods'),
    ),
    'input' => array(
        array(
            'type' => 'select',
            'label' => $this->l('Default service code'),
            'name' => 'ApaczkaServiceCode',
            'required' => true,
            'options' => array(
                'query' => array(
                    array(
                        'id_option' => 'UPS Zagranica',
                        'name' => 'UPS Zagranica'
                    ),
                    array(
                        'id_option' => 'UPS Standard',
                        'name' => 'UPS Standard'
                    ),
                    array(
                        'id_option' => 'UPS Express Saver KRAJ',
                        'name' => 'UPS Express Saver KRAJ'
                    ),
                    array(
                        'id_option' => 'UPS Express Saver ZAGR',
                        'name' => 'UPS Express Saver ZAGR'
                    ),
                    array(
                        'id_option' => 'DHL Standard',
                        'name' => 'DHL Standard'
                    ),
                    array(
                        'id_option' => 'DHL Express 12',
                        'name' => 'DHL Express 12'
                    ),
                array(
                        'id_option' => 'DPD Classic Foreign',
                        'name' => 'DPD Classic Foreign'
                    ),
                array(
                        'id_option' => 'TNT Economy Express',
                        'name' => 'TNT Economy Express'
                    ),
                array(
                        'id_option' => 'Pocztex 24',
                        'name' => 'Pocztex 24'
                    ),
                    array(
                        'id_option' => 'K-EX Express',
                        'name' => 'K-EX Express'
                    ),
                    array(
                        'id_option' => 'FEDEX',
                        'name' => 'FEDEX'
                    ),
                array(
                        'id_option' => 'INPOST',
                        'name' => 'INPOST'
                    ),
                    array(
                        'id_option' => 'DPD Classic',
                        'name' => 'DPD Classic'
                    )
                ),
                'id' => 'id_option',
                'name' => 'name'
            )
        ),
        array(
            'type' => 'select',
            'label' => $this->l('Default insurance: '),
            'name' => 'ApaczkaInsurance',
            'required' => true,
            'options' => array(
                'query' => array(
                    array(
                        'id_option' => 'insurOn',
                        'name' => 'Tak'
                    ),
                    array(
                        'id_option' => 'insurOff',
                        'name' => 'Nie'
                    ),
                ),
                'id' => 'id_option',
                'name' => 'name'
            )
        ),
        
        array(
            'type' => 'select',
            'label' => $this->l('Default pickup type: '),
            'name' => 'ApaczkaOrderPickupType',
            'required' => true,
            'options' => array(
                'query' => array(
                    array(
                        'id_option' => 'SELF',
                        'name' => 'Self delivery to courier'
                    ),
                    array(
                        'id_option' => 'COURIER',
                        'name' => 'Order the courier'
                    ),
                ),
                'id' => 'id_option',
                'name' => 'name'
            )
        )
    ),
    'submit' => array(
        'title' => $this->l('Save'),
        'class' => 'button'
    )
);
//*************************************************************************
$fields_form[2]['form'] = array(
    'legend' => array(
        'title' => $this->l('Sender informations'),
    ),
    'input' => array(
        array(
            'type' => 'text',
            'label' => $this->l('Name'),
            'name' => 'ApaczkaSenderName',
            'size' => 20,
            'maxlength' => 35,
            'required' => true
        ),
        array(
            'type' => 'text',
            'label' => $this->l('Address'),
            'name' => 'ApaczkaSenderAddress1',
            'size' => 20,
            'maxlength' => 35,
            'required' => true
        ),
        array(
            'type' => 'text',
            'label' => $this->l('Address cd'),
            'name' => 'ApaczkaSenderAddress2',
            'size' => 20,
            'maxlength' => 35,
            'required' => false
        ),
        array(
            'type' => 'text',
            'label' => $this->l('Zip Code'),
            'name' => 'ApaczkaSenderPostalCode',
            'size' => 20,
            'maxlength' => 6,
            'required' => true
        ),
        array(
            'type' => 'text',
            'label' => $this->l('City'),
            'name' => 'ApaczkaSenderCity',
            'size' => 20,
            'maxlength' => 35,
            'required' => true
        ),
        array(
            'type' => 'select',
            'label' => $this->l('Country'),
            'desc' => $this->l('Only for UPS zagranica'), // A help text, displayed right next to the <select> tag.
            'name' => 'ApaczkaSenderCountry',
            'required' => true,
            'options' => array(
                'query' => $countries,
                'id' => 'id',
                'name' => 'name'
            )
        ),
        array(
            'type' => 'text',
            'label' => $this->l('Contact name'),
            'name' => 'ApaczkaSenderContactName',
            'size' => 20,
            'required' => true
        ),
        array(
            'type' => 'text',
            'label' => $this->l('Phone'),
            'name' => 'ApaczkaSenderPhone',
            'size' => 20,
            'maxlength' => 15,
            'required' => true
        ),
        array(
            'type' => 'text',
            'label' => $this->l('E-mail'),
            'name' => 'ApaczkaSenderEmail',
            'size' => 30,
            'maxlength' => 100,
            'required' => true
        ),
        array(
            'type' => 'text',
            'label' => $this->l('Sender Account'),
            'name' => 'ApaczkaSenderAccount',
            'size' => 30,
            'required' => true
        )
    ),
    'submit' => array(
        'title' => $this->l('Save'),
        'class' => 'button'
    )
);

//*************************************************************************
$fields_form[3]['form'] = array(
    'legend' => array(
        'title' => $this->l('Default parcel settings'),
    ),
    'input' => array(
        array(
            'type' => 'text',
            'label' => $this->l('Invoice referal:'),
            'name' => 'ApaczkaRefText',
            'size' => 20,
            'maxlength' => 5,
            'required' => false
        ),
        array(
            'type' => 'text',
            'label' => $this->l('Default content'),
            'name' => 'ApaczkaContent',
            'size' => 20,
            'maxlength' => 40,
            'required' => true
        ),
        array(
            'type' => 'text',
            'label' => $this->l('Default weight'),
            'name' => 'ApaczkaWeight',
            'size' => 20,
            'maxlength' => 2,
            'suffix' => 'KG',
            'required' => true
        ),
        array(
            'type' => 'label',
            'label' => $this->l('Default dimensions:'),
            'name' => 'prompt1'
        ),
        array(
            'type' => 'text',
            'label' => $this->l('Dimension 1'),
            'name' => 'ApaczkaDim1',
            'size' => 20,
            'maxlength' => 3,
            'required' => true,
            'suffix' => 'CM'
        ),
        array(
            'type' => 'text',
            'label' => $this->l('Dimension 2'),
            'name' => 'ApaczkaDim2',
            'size' => 20,
            'maxlength' => 3,
            'required' => true,
            'suffix' => 'CM'
        ),
        array(
            'type' => 'text',
            'label' => $this->l('Dimension 3'),
            'name' => 'ApaczkaDim3',
            'size' => 20,
            'maxlength' => 3,
            'required' => true,
            'suffix' => 'CM'
        )
    ),
    'submit' => array(
        'title' => $this->l('Save'),
        'class' => 'button'
    )
);

//*************************************************************************
$fields_form[4]['form'] = array(
    'legend' => array(
        'title' => $this->l('Notifications settings'),
    ),
    'input' => array(
        array(
            'type' => 'label',
            'name' => 'prompt2',
            'label' => $this->l('Sender notifications '),
           
        ),
        array(
            'type' => 'radio',
            'label' => $this->l('Delivered'),
            'name' => 'ApaczkaSenderDelivered',
            'is_bool' => true,
            'class' => 'radio-inline',
            'values' => array(
                array(
                    'id' => 'active_onApaczkaSenderDelivered',
                    'value' => 1,
                    'label' => $this->l('Tak')
                ),
                array(
                    'id' => 'active_offApaczkaSenderDelivered',
                    'value' => 0,
                    'label' => $this->l('Nie')
                )
            )
        ),
        array(
            'type' => 'radio',
            'label' => $this->l('Exception'),
            'name' => 'ApaczkaSenderException',
            'is_bool' => true,
            'class' => 'radio-inline',
            'values' => array(
                array(
                    'id' => 'active_onApaczkaSenderException',
                    'value' => 1,
                    'label' => $this->l('Tak')
                ),
                array(
                    'id' => 'active_offApaczkaSenderException',
                    'value' => 0,
                    'label' => $this->l('Nie')
                )
            )
        ),
        array(
            'type' => 'radio',
            'label' => $this->l('Register'),
            'name' => 'ApaczkaSenderRegister',
            'is_bool' => true,
            'class' => 'radio-inline',
            'values' => array(
                array(
                    'id' => 'active_onApaczkaSenderRegister',
                    'value' => 1,
                    'label' => $this->l('Tak')
                ),
                array(
                    'id' => 'active_offApaczkaSenderRegister',
                    'value' => 0,
                    'label' => $this->l('Nie')
                )
            )
        ),
        array(
            'type' => 'radio',
            'label' => $this->l('Sent'),
            'name' => 'ApaczkaSenderSent',
            'is_bool' => true,
            'class' => 'radio-inline',
            'values' => array(
                array(
                    'id' => 'active_onApaczkaSenderSent',
                    'value' => 1,
                    'label' => $this->l('Tak')
                ),
                array(
                    'id' => 'active_offApaczkaSenderSent',
                    'value' => 0,
                    'label' => $this->l('Nie')
                )
            )
        ),
        array(
            'type' => 'label',
            'name' => 'prompt2',
            'label' => $this->l('Receiver notifications ')
        ),
        array(
            'type' => 'radio',
            'label' => $this->l('Delivered'),
            'name' => 'ApaczkaReceiverDelivered',
            'is_bool' => true,
            'class' => 'radio-inline',
            'values' => array(
                array(
                    'id' => 'active_onApaczkaReceiverDelivered',
                    'value' => 1,
                    'label' => $this->l('Tak')
                ),
                array(
                    'id' => 'active_offApaczkaReceiverDelivered',
                    'value' => 0,
                    'label' => $this->l('Nie')
                )
            )
        ),
        array(
            'type' => 'radio',
            'label' => $this->l('Exception'),
            'name' => 'ApaczkaReceiverException',
            'is_bool' => true,
            'class' => 'radio-inline',
            'values' => array(
                array(
                    'id' => 'active_onApaczkaReceiverException',
                    'value' => 1,
                    'label' => $this->l('Tak')
                ),
                array(
                    'id' => 'active_offApaczkaReceiverException',
                    'value' => 0,
                    'label' => $this->l('Nie')
                )
            )
        ),
        array(
            'type' => 'radio',
            'label' => $this->l('Registered'),
            'name' => 'ApaczkaReceiverRegister',
            'is_bool' => true,
            'class' => 'radio-inline',
            'values' => array(
                array(
                    'id' => 'active_onApaczkaReceiverRegister',
                    'value' => 1,
                    'label' => $this->l('Tak')
                ),
                array(
                    'id' => 'active_offApaczkaReceiverRegister',
                    'value' => 0,
                    'label' => $this->l('Nie')
                )
            )
        ),
        array(
            'type' => 'radio',
            'label' => $this->l('Sent'),
            'name' => 'ApaczkaReceiverSent',
            'is_bool' => true,
            'class' => 'radio-inline',
            'values' => array(
                array(
                    'id' => 'active_onApaczkaReceiverSent',
                    'value' => 1,
                    'label' => $this->l('Tak')
                ),
                array(
                    'id' => 'active_offApaczkaReceiverSent',
                    'value' => 0,
                    'label' => $this->l('Nie')
                )
            )
        )
    ),
    'submit' => array(
        'title' => $this->l('Save'),
        'class' => 'button'
    )
);
