{*
* 2007-2019 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2019 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
{extends file='page.tpl'}


{block name='page_header_container'}{/block}

{block name="page_content_container"}
	<section id="content" class="page-content">
	{if isset($inspblogpost) && !empty($inspblogpost)}
	<div class="kr_blog_post_area">
		<div class="kr_blog_post_inner blog_style_{$inspblogsettings.blog_style} column_{$inspblogsettings.blog_no_of_col} row">
			{foreach from=$inspblogpost item=xpblgpst}
				<article id="blog_post" class="blog_post blog_post_{$xpblgpst.post_format} clearfix col-xl-4 col-lg-6 col-md-6 col-sm-6 col-xs-12">
					<div class="post-bo">
					<div class="blog_post_content">
						
						<div class="blog_post_content_top col-xs-12">
							<div class="post_thumbnail row">
							{block name="inspblog_post_thumbnail"}
								{if $xpblgpst.post_format == 'video'}
									{assign var="postvideos" value=','|explode:$xpblgpst.video}
									{if $postvideos|@count > 1 }
										{assign var="class" value='carousel'}
									{else}
										{assign var="class" value=''}
									{/if}
									{include file="module:inspblog/views/templates/front/default/post-video.tpl" postvideos=$postvideos width='870' height="482" class=$class}
								{elseif $xpblgpst.post_format == 'audio'}
									{assign var="postaudio" value=','|explode:$xpblgpst.audio}
									{if $postaudio|@count > 1 }
										{assign var="class" value='carousel'}
									{else}
										{assign var="class" value=''}
									{/if}
									{include file="module:inspblog/views/templates/front/default/post-audio.tpl" postaudio=$postaudio class=$class}
								{elseif $xpblgpst.post_format == 'gallery'}
									{if $xpblgpst.gallery_lists|@count > 1 }
										{assign var="class" value='carousel'}
									{else}
										{assign var="class" value=''}
									{/if}
									{include file="module:inspblog/views/templates/front/default/post-gallery.tpl" gallery_lists=$xpblgpst.gallery_lists imagesize="large" class=$class}
								{else}
									<img class="img-responsive" src="{$xpblgpst.post_img_large}" alt="{$xpblgpst.post_title}">
									{* <div class="blog_mask">
										<div class="blog_mask_content">
											<a class="thumbnail_lightbox" href="{$xpblgpst.post_img_large}" data-lightbox="example-set">
												<i class="fa fa-search-plus"></i>
											</a>										
										</div>
									</div> *}
								{/if}
							{/block}
							</div>
						</div>

						<div class="blog_post_content_bottom col-xs-12">
							
							<div class="blog-e">
							<div class="post_meta clearfix">
								
									
								
								<div class="meta_author">
									{* <i class="icon-user"></i> *}
									<span>{l s='By' mod='inspblog'} {$xpblgpst.post_author_arr.firstname} {$xpblgpst.post_author_arr.lastname}</span>
								</div>

								<h3 class="post_title"><a href="{$xpblgpst.link}">{$xpblgpst.post_title}</a></h3>

								<div class="post_meta_date">
									<i class="fa fa-calendar"></i>
									{$xpblgpst.post_date|date_format:"%b %dth, %Y"}
								</div>

								<div class="meta_category">
										<i class="fa fa-list"></i>
										<span>{l s='In' mod='inspblog'}</span>
										<a href="{$xpblgpst.category_def_arr.link}">{$xpblgpst.category_def_arr.name}</a>
								</div>
								<div class="meta_comment">
									<i class="fa fa-eye"></i>
									<span>{l s='Views' mod='inspblog'} ({$xpblgpst.comment_count})</span>
								</div> 
							</div>

							<div class="post_content">
								{if isset($xpblgpst.post_excerpt) && !empty($xpblgpst.post_excerpt)}
									{$xpblgpst.post_excerpt|truncate:180:'...'|escape:'html':'UTF-8'}
								{else}
									{$xpblgpst.post_content|truncate:180:'...'|escape:'html':'UTF-8'}
								{/if}
							</div>
							<div class="content_more">
								<a class="read_more" href="{$xpblgpst.link}">{l s='Read more' mod='inspblog'}</a>
							</div>
						</div>
					</div>
					</div>
					</div>
				</article>
			{/foreach}
		</div>
	</div>
	{/if}
	</section>
{/block}
{include file="module:inspblog/views/templates/front/default/pagination.tpl"}
{* {/block}  *}
{block name="left_column"}
	{assign var="layout_column" value=$layout|replace:'layouts/':''|replace:'.tpl':''|strval}
	{if ($layout_column == 'layout-left-column')}
		<div id="left-column" class="col-xs-12 col-sm-4 col-md-4 col-lg-3">
			{if ($inspblog_column_use == 'own_ps')}
				{hook h="displayinspblogleft"}
			{else}
				{hook h="displayLeftColumn"}
			{/if}
		</div>
	{/if}
{/block}
{block name="right_column"}
	{assign var="layout_column" value=$layout|replace:'layouts/':''|replace:'.tpl':''|strval}
	{if ($layout_column == 'layout-right-column')}
		<div id="right-column" class="sidebar col-xs-12 col-sm-4 col-md-3">
			{if ($inspblog_column_use == 'own_ps')}
				{hook h="displayinspblogright"}
			{else}
				{hook h="displayRightColumn"}
			{/if}
		</div>
	{/if}
{/block}