{*
* 2007-2019 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2019 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
{extends file='page.tpl'}

{block name='page_header_container'}{/block}


{block name="page_content_container"}
<div class="row">
	<section id="content" class="page-content col-lg-6 col-md-6 col-sm-6 col-xs-12">
		<div class="kr_blog_post_area single">
			<div class="kr_blog_post_inner">
				<article id="blog_post" class="blog_post blog_post_{$inspblogpost.post_format}">
					<div class="blog_post_content">
						<h3 class="post_title">{$inspblogpost.post_title}</h3>
						<div class="blog_post_content_top">
							<div class="post_thumbnail">
								{if $inspblogpost.post_format == 'video'}
									{assign var="postvideos" value=','|explode:$inspblogpost.video}
									{if $postvideos|@count > 1 }
										{assign var="class" value='carousel'}
									{else}
										{assign var="class" value=''}
									{/if}
									{include file="module:inspblog/views/templates/front/default/post-video.tpl" postvideos=$postvideos width='870' height="482" class=$class}
								{elseif $inspblogpost.post_format == 'audio'}
									{assign var="postaudio" value=','|explode:$inspblogpost.audio}
									{if $postaudio|@count > 1 }
										{assign var="class" value='carousel'}
									{else}
										{assign var="class" value=''}
									{/if}
									{include file="module:inspblog/views/templates/front/default/post-audio.tpl" postaudio=$postaudio width='870' height="482" class=$class}
								{elseif $inspblogpost.post_format == 'gallery'}
									{if $inspblogpost.gallery_lists|@count > 1 }
										{assign var="class" value='carousel'}
									{else}
										{assign var="class" value=''}
									{/if}
									{include file="module:inspblog/views/templates/front/default/post-gallery.tpl" gallery_lists=$inspblogpost.gallery_lists imagesize="medium" class=$class}
								{else}
									<img class="inspblog_img img-responsive" src="{$inspblogpost.post_img_large}" alt="{$inspblogpost.post_title}">
								{/if}
							</div>
						</div>

						<div class="blog_post_content_bottom">
							
							<div class="post_meta clearfix">
								<div class="meta_author">
									{* <i class="icon-user"></i> *}
									<span>{l s='By' mod='inspblog'} {$inspblogpost.post_author_arr.firstname} {$inspblogpost.post_author_arr.lastname}</span>
								</div>
								<div class="meta_category">
									{* <i class="icon-tag"></i> *}
									<i class="fa fa-list"></i>
									<span>{l s='In' mod='inspblog'}</span>
									<span>{$inspblogpost.category_def_arr.name}</span>
								</div>
								<div class="meta_comment">
									{* <i class="icon-eye"></i> *}
									<i class="fa fa-eye"></i>
									<span>{l s='Views' mod='inspblog'} ({$inspblogpost.comment_count})</span>
								</div>
							</div>
							<div class="post_content">
								{$inspblogpost.post_content nofilter}
							</div>
						</div>

					</div>
				</article>
			</div>
		</div>
	</section>
{if ($inspblogpost.comment_status == 'open') || ($inspblogpost.comment_status == 'close')}
	{include file="module:inspblog/views/templates/front/default/comment-list.tpl"}
{/if}
{if (isset($disable_blog_com) && $disable_blog_com == 1) && ($inspblogpost.comment_status == 'open')}
			{include file="module:inspblog/views/templates/front/default/comment.tpl"}
{/if}
{/block}
</div>
{block name="left_column"}
	{assign var="layout_column" value=$layout|replace:'layouts/':''|replace:'.tpl':''|strval}
	{if ($layout_column == 'layout-left-column')}
		<div id="left-column" class="col-xs-12 col-sm-4 col-md-4 col-lg-3">
			{if ($inspblog_column_use == 'own_ps')}
				{hook h="displayinspblogleft"}
			{else}
				{hook h="displayLeftColumn"}
			{/if}
		</div>
	{/if}
{/block}
{block name="right_column"}
	{assign var="layout_column" value=$layout|replace:'layouts/':''|replace:'.tpl':''|strval}
	{if ($layout_column == 'layout-right-column')}
		<div id="right-column" class="sidebar col-xs-12 col-sm-4 col-md-3">
			{if ($inspblog_column_use == 'own_ps')}
				{hook h="displayinspblogright"}
			{else}
				{hook h="displayRightColumn"}
			{/if}
		</div>
	{/if}
{/block}