<?php
/**
* 2007-2018 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2018 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

$sql = array();

$sql[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'inspgroupcategory` (
    `id_inspgroupcategory` int(11) NOT NULL AUTO_INCREMENT,
    `group_cat` varchar(255) NOT NULL,
    `id_hook` varchar(255) NOT NULL,
    `type_display` varchar(255) NOT NULL,
    `num_show` int(10) unsigned NOT NULL,
    `use_slider` int(10) unsigned NOT NULL,
    `show_sub` int(10) unsigned NOT NULL,
    `active` tinyint(1) unsigned NOT NULL DEFAULT \'0\',
    PRIMARY KEY  (`id_inspgroupcategory`)
) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';

$sql[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'inspgroupcategory_shop` (
    `id_inspgroupcategory` int(11) NOT NULL AUTO_INCREMENT,
    `group_cat` varchar(255) NOT NULL,
    `id_shop` int(10) unsigned NOT NULL,
    `id_hook` varchar(255) NOT NULL,
    `type_display` varchar(255) NOT NULL,
    `num_show` int(10) unsigned NOT NULL,
    `use_slider` int(10) unsigned NOT NULL,
    `show_sub` int(10) unsigned NOT NULL,
    `active` tinyint(1) unsigned NOT NULL DEFAULT \'0\',
    PRIMARY KEY  (`id_inspgroupcategory`, `id_shop`)
) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';

$sql[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'inspirecategory` (
      `id_inspirecategory` int(10) unsigned NOT NULL AUTO_INCREMENT,
      `id_inspgroupcategory` int(10) unsigned NOT NULL,
      `id_cat` int(10) unsigned NOT NULL,
      `cat_icon` varchar(255) NOT NULL,
      `cat_color` varchar(255) NOT NULL,
      `manufacture` varchar(255) NOT NULL,
      `position` int(10) unsigned NOT NULL DEFAULT \'0\',
      `show_img` int(10) unsigned NOT NULL,
      `special_prod` int(10) unsigned NOT NULL,
      `active` int(10) unsigned NOT NULL,
      PRIMARY KEY (`id_inspirecategory`)
    ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;';
    
$sql[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'inspirecategory_shop` (
      `id_inspirecategory` int(10) unsigned NOT NULL AUTO_INCREMENT,
      `id_inspgroupcategory` int(10) unsigned NOT NULL,
      `id_shop` int(10) unsigned NOT NULL,
      `id_cat` int(10) unsigned NOT NULL,
      `cat_icon` varchar(255) NOT NULL,
      `cat_color` varchar(255) NOT NULL,
      `manufacture` varchar(255) NOT NULL,
      `position` int(10) unsigned NOT NULL DEFAULT \'0\',
      `show_img` int(10) unsigned NOT NULL,
      `special_prod` int(10) unsigned NOT NULL,
      `active` int(10) unsigned NOT NULL,
      PRIMARY KEY (`id_inspirecategory`, `id_shop`)
    ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;';
    
$sql[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'inspirecategory_lang` (
      `id_inspirecategory` int(10) unsigned NOT NULL AUTO_INCREMENT,
      `id_shop` int(10) unsigned NOT NULL,
      `id_lang` int(10) unsigned NOT NULL,
      `cat_desc` text NOT NULL,
      `cat_banner` varchar(255) NOT NULL,
      PRIMARY KEY (`id_inspirecategory`, `id_shop`, `id_lang`)
    ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;';

$languages = Language::getLanguages(true);
$id_shop = Configuration::get('PS_SHOP_DEFAULT');
$sql[] = 'INSERT IGNORE INTO `'._DB_PREFIX_.'inspgroupcategory` (
      `id_inspgroupcategory`,
      `group_cat`,
      `id_hook`,
      `type_display`,
      `num_show`,
      `use_slider`,
      `show_sub`,
      `active`
    ) VALUES
    (1, "Group category", "displayHome", "tab", 16, 1, 0, 1);';
$sql[] = 'INSERT IGNORE INTO `'._DB_PREFIX_.'inspgroupcategory_shop` (
    `id_inspgroupcategory`,
    `group_cat`,
    `id_shop`,
    `id_hook`,
    `type_display`,
    `num_show`,
    `use_slider`,
    `show_sub`,
    `active`
  ) VALUES
    (1, "Group category", "'.$id_shop.'", "displayHome", "tab", 16, 1, 0, 1);';
$sql[] = 'INSERT IGNORE INTO `'._DB_PREFIX_.'inspirecategory` (
    `id_inspirecategory`,
    `id_inspgroupcategory`,
    `id_cat`,
    `cat_icon`,
    `cat_color`,
    `manufacture`,
    `position`,
    `show_img`,
    `special_prod`,
    `active`
  ) VALUES
    (1, 1, 3, "9b661fd57b3bfbedee8a33580f5ca65252895633_icon_1.png", "", "false", 1, 0, 0, 1),
    (2, 1, 4, "24302b2feda22e80dd7cca642cfc487f086be978_icon_2.png", "", "false", 1, 0, 0, 1),
    (3, 1, 5, "24302b2feda22e80dd7cca642cfc487f086be978_icon_3.png", "", "false", 1, 0, 0, 1);';
$sql[] = 'INSERT IGNORE INTO `'._DB_PREFIX_.'inspirecategory_shop` (
    `id_inspirecategory`,
    `id_inspgroupcategory`,
    `id_shop`, `id_cat`,
    `cat_icon`,
    `cat_color`,
    `manufacture`,
    `position`,
    `show_img`,
    `special_prod`,
    `active`
  ) VALUES
    (1, 1, "'.$id_shop.'", 3, "9b661fd57b3bfbedee8a33580f5ca65252895633_icon_1.png", "", "false", 1, 0, 0, 1),
    (2, 1, "'.$id_shop.'", 4, "24302b2feda22e80dd7cca642cfc487f086be978_icon_2.png", "", "false", 1, 0, 0, 1),
    (3, 1, "'.$id_shop.'", 5, "24302b2feda22e80dd7cca642cfc487f086be978_icon_3.png", "", "false", 1, 0, 0, 1);';
foreach ($languages as $language) {
    $sql[] = 'INSERT IGNORE INTO `'._DB_PREFIX_.'inspirecategory_lang` (
        `id_inspirecategory`, `id_shop`, `id_lang`, `cat_desc`, `cat_banner`) VALUES
        (1, "'.$id_shop.'", "'.$language['id_lang'].'", "", "banner1.jpg"),
        (2, "'.$id_shop.'", "'.$language['id_lang'].'", "", "banner2.jpg"),
        (3, "'.$id_shop.'", "'.$language['id_lang'].'", "", "banner3.jpg");';
}

foreach ($sql as $query) {
    if (Db::getInstance()->execute($query) == false) {
        return false;
    }
}
