{**
 * 2007-2018 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2018 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
{block name='product_miniature_item'}
  <article class="product-miniature js-product-miniature col-xs-12 col-less" data-id-product="{$product.id_product}" data-id-product-attribute="{$product.id_product_attribute}" itemscope itemtype="http://schema.org/Product">
    <div class="thumbnail-container homeprd">
     <div class="ab-image-block">
      {block name='product_thumbnail'}
      {if $product.cover}
          <a href="{$product.url}" class="thumbnail product-thumbnail">
            <img
              class = "center-block img-responsive"
              src = "{$product.cover.bySize.home_default.url}"
              alt = "{if !empty($product.cover.legend)}{$product.cover.legend}{else}{$product.name}{/if}"
              data-full-size-image-url = "{$product.cover.large.url}"
              width="{$product.cover.bySize.home_default.width}" height="{$product.cover.bySize.home_default.height}"
            >
            {$count=0}
           {foreach from=$product.images item=image}
            {if $count==0}
              <img class="new-sec-img img-responsive center-block"  
                src="{$image.bySize.home_default.url}"
                alt="{$image.legend}"
                title="{$image.legend}"
                itemprop="image"
                width="{$product.cover.bySize.home_default.width}" height="{$product.cover.bySize.home_default.height}"
              >
              {/if} {$count=$count+1}
        {/foreach}
         <!--   {if $product.discount_type === 'percentage'}
              <span class="sale">{$product.discount_percentage}</span>
            {/if} -->
{*      {block name='product_flags'}*}
{*        <ul class="product-flags">*}
{*          {foreach from=$product.flags item=flag}*}
{*            <li class="product-flag {$flag.type}"><span>{$flag.label}</span></li>*}
{*          {/foreach}*}

{*        </ul>*}
{*      {/block}       *}

          </a>
        {else}
          <a href="{$product.url}" class="thumbnail product-thumbnail">
            <img
              class="img-responsive center-block"
              src = "{$urls.no_picture_image.bySize.home_default.url}"
            >
          </a>
        {/if}
      {/block}
       
</div>
      <div class="ab-product-desc text-xs-center">
      

        {block name='product_name'}
          {if $page.page_name == 'index'}
            <h3 class="h3 product-title" itemprop="name"><a href="{$product.url}">{$product.name}</a></h3>
          {else}
            <h2 class="h3 product-title" itemprop="name"><a href="{$product.url}">{$product.name}</a></h2>
          {/if}
        {/block}

        {block name='product_description_short'}
          <div id="product-description-short-{$product.id}" itemprop="description" class="p-des">{$product.description_short nofilter}</div>
        {/block}

        {block name='product_reviews'}
          {hook h='displayProductListReviews' product=$product}
        {/block}


        {block name='product_price_and_shipping'}
          {if $product.show_price}
            <div class="product-price-and-shipping">
              <span itemprop="price" class="price">{$product.price}</span>
              {if $product.has_discount}
                {hook h='displayProductPriceBlock' product=$product type="old_price"}
                <span class="sr-only">{l s='Regular price' d='Shop.Theme.Catalog'}</span>
                <span class="regular-price">{$product.regular_price}</span>
              {/if}
              {hook h='displayProductPriceBlock' product=$product type="before_price"}
              <span class="sr-only">{l s='Price' d='Shop.Theme.Catalog'}</span>
              {hook h='displayProductPriceBlock' product=$product type='unit_price'}
            
        
        
      
  
            
              <div class="clearfix bootstrap-touchspin">
                <label>{l s='Ilość' d='Shop.Theme.Catalog'}</label>
                <div class="quantity">

                <input name="qty" type="text" min="{$product.minimal_quantity}" class="form-control atc_qty" value="1" onfocus="if(this.value == '1') this.value = '';" onblur="if(this.value == '') this.value = '1';"/>
                </div>
                <button class="insp-cart-button" onclick="mypresta_productListCart.add({literal}$(this){/literal}); window.location.reload(true);">
                    <svg width="18px" height="18px" class=""><use xlink:href="#addcart"></use></svg>
                </button>
              </div>

              </div>
          
            {/if}
          {/block}
        
        

        <!--buttons-->
        <div class="insp-abs-button">
{*          <div class="topbutton d-inline-block">*}
{*            <!-- <div class="add-cart">*}
{*              <form action="{$urls.pages.cart}" method="post" class="add-to-cart-or-refresh">*}
{*              <input type="hidden" name="token" value="{$static_token}">*}
{*              <input type="hidden" name="id_product" value="{$product.id}" class="product_page_product_id">*}
{*              <input type="hidden" name="qty" value="1">*}
{*              {if $product.quantity < 1 }*}
{*              <button data-toggle="tooltip" title="Out of stock" data-button-action="add-to-cart" class="insp-cart-button" disabled>*}
{*                   <svg width="18px" height="18px" class=""><use xlink:href="#addcart"></use></svg><span>{l s='out of stock' d='Shop.Theme.Catalog'}</span>*}
{*              </button>*}
{*              {else}*}
{*              <button  data-toggle="tooltip" title="Add to cart" data-button-action="add-to-cart" class="insp-cart-button">*}
{*                 <svg width="18px" height="18px" class=""><use xlink:href="#addcart"></use></svg>*}
{*                <span class="dn">{l s='add to cart' d='Shop.Theme.Catalog'}</span>*}
{*              </button>*}
{*              {/if}*}
{*              </form>*}
{*            </div> -->              *}

{*              {block name='quick_view'}*}
{*                <a class="quick-view" href="#" data-link-action="quickview">*}
{*                   <svg width="17px" height="18px"><use xlink:href="#proquick" /></svg>*}
{*                   <span class="dn">{l s='Quick view' d='Shop.Theme.Actions'}</span>*}
{*                </a>*}
{*              {/block} *}

{*              <button data-toggle="tooltip" title="Wishlist" class="wish" id="wishlist_button" onclick="WishlistCart('wishlist_block_list', 'add', '{$product.id_product|intval}', {$product.id_product_attribute}, 1); return false;"><svg width="18px" height="17px"><use xlink:href="#addwish"></use></svg>*}{* <span>{l s='wishlist' d='Shop.Theme.Catalog'}</span> *}{*</button>*}

{*              {hook h='displayCompareButton' product=$product}*}
{*                   *}
{*          </div> *}
        </div> 
       <!--button end -->

       
      </div>
    </div>
  </article>
{/block}