<?php
/**
 * @author     Apaczka.pl <bok@apaczka.pl>
 * @copyright  Apaczka.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage ApaczkaShipping
 * @link       https://www.apaczka.pl
 * @since      1.0.0
 * @theme_key  330670a5d241bfe6794d0535db3999b4
 */

if (! defined('_PS_VERSION_')) {
    exit;
}

require_once(_PS_MODULE_DIR_ . "apaczkashipping/apaczkaSoapClient.php");

//******************************************************************************
//********************** CLASS APACZKASHIPPING *********************************
//******************************************************************************

class ApaczkaShipping extends CarrierModule
{

    private $debugMode = false;

    public function __construct()
    {
        $this->name                   = 'apaczkashipping';
        $this->tab                    = 'shipping_logistics';
        $this->version                = '1.0.1';
        $this->module_key             = '330670a5d241bfe6794d0535db3999b4';
        $this->author                 = 'Apaczka.pl';
        $this->need_instance          = 0;
        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => '1.8');
        parent::__construct();
        $this->displayName      = $this->l('Apaczka.pl');
        $this->description      = $this->l('Quick and fast delivery with Apaczka.pl');
        $this->confirmUninstall = $this->l('Are you sure?');
        $this->bootstrap        = true;
        $this->defaultVar();        //Loading configuration variables
    }

//******************************************************************************
    public function defaultVar()
    {
// Loading Fields List

        $this->_fieldsList = array(
            'countries'                        => '',
            'apaczka_login'                    => '',
            'apaczka_password'                 => '',
            'apaczka_apikey'                   => '',
            'apaczka_test'                     => '',
            'apaczka_sender_postcode'          => '',
            'apaczka_sender_city'              => '',
            'apaczka_sender_country'           => '',
            'apaczka_sender_shop_name'         => '',
            'apaczka_sender_address1'          => '',
            'apaczka_sender_address2'          => '',
            'apaczka_sender_postcode'          => '',
            'apaczka_sender_contactName'       => '',
            'apaczka_sender_phone'             => '',
            'apaczka_sender_email'             => '',
            //**************************
            'apaczka_shipment_price'           => '',
            'apaczka_account'                  => '',
            'apaczka_contents'                 => '',
            'apaczka_serviceCode'              => '',
            'apaczka_insurance'                => '',
            'apaczka_orderPickupType'          => '',
            'apaczka_ref_text'                 => '',
            'apaczka_weight'                   => '',
            'apaczka_dimension1'               => '',
            'apaczka_dimension2'               => '',
            'apaczka_dimension3'               => '',
            //**************************
            'apaczka_sender_notif_delivered'   => '',
            'apaczka_sender_notif_exception'   => '',
            'apaczka_sender_notif_sent'        => '',
            'apaczka_sender_notif_register'    => '',
            'apaczka_receiver_notif_delivered' => '',
            'apaczka_receiver_notif_exception' => '',
            'apaczka_receiver_notif_sent'      => '',
            'apaczka_receiver_notif_register'  => ''
            //**************************
        );
    }

//******************************************************************************
    public function resetVar()
    {
        Configuration::updateValue('apaczka_login', '');
        Configuration::updateValue('apaczka_password', '');
        Configuration::updateValue('apaczka_apikey', '');
        Configuration::updateValue('apaczka_test', '');
        //*************************
        Configuration::updateValue('apaczka_sender_shop_name', '');
        Configuration::updateValue('apaczka_sender_address1', '');
        Configuration::updateValue('apaczka_sender_address2', '');
        Configuration::updateValue('apaczka_sender_postcode', '');
        Configuration::updateValue('apaczka_sender_city', '');
        Configuration::updateValue('apaczka_sender_country', '');
        Configuration::updateValue('apaczka_sender_contactName', '');
        Configuration::updateValue('apaczka_sender_phone', '');
        Configuration::updateValue('apaczka_sender_email', '');
        Configuration::updateValue('apaczka_account', '');
        //*************************
        Configuration::updateValue('apaczka_ref_text', '');
        Configuration::updateValue('apaczka_contents', '');
        Configuration::updateValue('apaczka_weight', '');
        Configuration::updateValue('apaczka_dimension1', '');
        Configuration::updateValue('apaczka_dimension2', '');
        Configuration::updateValue('apaczka_dimension3', '');
        //*************************
        Configuration::updateValue('apaczka_sender_notif_delivered', '');
        Configuration::updateValue('apaczka_sender_notif_exception', '');
        Configuration::updateValue('apaczka_sender_notif_register', '');
        Configuration::updateValue('apaczka_sender_notif_sent', '');
        Configuration::updateValue('apaczka_receiver_notif_delivered', '');
        Configuration::updateValue('apaczka_receiver_notif_exception', '');
        Configuration::updateValue('apaczka_receiver_notif_register', '');
        Configuration::updateValue('apaczka_receiver_notif_sent', '');
        //*************************
        Configuration::updateValue('apaczka_insurance', '');
        Configuration::updateValue('apaczka_orderPickupType', '');
        Configuration::updateValue('apaczka_serviceCode', '');
    }

//******************************************************************************
    public function install()
    {

        if (! parent::install() || ! $this->createTables() || ! $this->registerHook('displayAdminOrder')) {
            return false;
        }
        if (! extension_loaded('soap')) {
            return false;
        }

        return true;
    }

//******************************************************************************
    public function uninstall()
    {
        Db::getInstance()->update('carrier', array('deleted' => 1), '`external_module_name` = \'apaczkacarrier\'');


        $sql = 'DROP TABLE IF EXISTS `apaczka_address_book`;';
        if (! Db::getInstance()->execute($sql)) {
            return false;
        }
        /* $sql = 'DROP TABLE IF EXISTS `apaczka_orders`;';      //does not drop because customers will loose their saved orders
          if (!Db::getInstance()->execute($sql)) {
          return false;
          } */
        $this->resetVar();
        if (! parent::uninstall()) {
            return false;
        }

        return true;
    }

//******************************************************************************

    public function enable($forceAll = false)
    {
        Db::getInstance()->update('carrier', array('active' => 1), '`external_module_name` = \'apaczkacarrier\'');
        parent::enable($forceAll);
    }

//******************************************************************************
    public function disable($forceAll = false)
    {
        Db::getInstance()->update('carrier', array('active' => 0), '`external_module_name` = \'apaczkacarrier\'');
        parent::disable($forceAll);
    }

//******************************************************************************
    public function createTables()
    {

        $sql
            = 'CREATE TABLE IF NOT EXISTS `apaczka_address_book` (
			`contact_id` int(10) NOT NULL AUTO_INCREMENT,
			`nazwa` varchar(35) NOT NULL,
            `adres` varchar(35) NOT NULL,
            `adres2` varchar(35),
            `kod_pocztowy` varchar(7) NOT NULL,
            `miasto` varchar(35) NOT NULL,
            `id_kraju` int(12) NOT NULL,
            `osoba_kontaktowa` varchar(35) NOT NULL,
            `telefon` varchar(15) NOT NULL,
            `email` varchar(100),
            `konto_pobraniowe` varchar(40) NOT NULL,
            PRIMARY KEY  (`contact_id`),
            UNIQUE (`nazwa`, `miasto`,`adres`, `konto_pobraniowe`)
                ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;';
        if (! Db::getInstance()->execute($sql)) {
            return false;
        }
        $sql
            = 'CREATE TABLE IF NOT EXISTS `apaczka_orders` (
			`id_order_presta` int(12) NOT NULL,
			`id_order_apaczka` int(14) NOT NULL,
                  `order_number_apaczka` varchar(24) NOT NULL,
			PRIMARY KEY  (`id_order_presta`)
		) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;';
        if (! Db::getInstance()->execute($sql)) {
            return false;
        }

        return true;
    }

    /*         * ************************ required by presta ************************ */    //without this, module doesn't work

    public function getOrderShippingCost($params, $shipping_cost)
    {

        return (float)100;
    }

    /*         * ************************ required by presta ************************ */    //without this, module doesn't work

    public function getOrderShippingCostExternal($params)
    {

        return (float)100;
    }

//******************************************************************************  

    /**
     * Prepares the Smarty variables for displaying the form after the error occurred during the shipment (Rewrites data from the old form).
     * In addition, it downloads an address book and a list of countries, checks whether a download service has been selected.
     *
     * @param type $params - order data.
     */
    public function smartyAssignOrderFormError($params)
    {
        $order = new Order((int)$params['id_order']);

        $sql    = 'SELECT * FROM apaczka_address_book';
        $result = Db::getInstance()->executeS($sql);

//                $cod = $order->module === 'ps_cashondelivery' ? 1 : 0; //Reads from the order whether the cod option has been chosen

        $countries = json_decode((string)Configuration::get('countries'));

        $this->context->smarty->assign(array(
            'countries'            => $countries,
            'contacts'             => $result,
            'cod'                  => (int)Tools::getValue('cod'),
            'id_order'             => $params['id_order'],
            'token'                => Tools::getValue('token'),
            'R_company'            => ((string)Tools::getValue('receiver_name')),
            'R_address1'           => ((string)Tools::getValue('receiver_addressLine1')),
            'R_address2'           => ((string)Tools::getValue('receiver_addressLine2')),
            'R_postcode'           => ((string)Tools::getValue('receiver_postalCode')),
            'R_city'               => ((string)Tools::getValue('receiver_city')),
            'R_country'            => (string)Tools::getValue('receiver_countryId'),
            'R_firstname'          => (string)Tools::getValue('receiver_contactName'),
            'R_lastname'           => '',
            'R_phone'              => (string)Tools::getValue('receiver_phone'),
            'R_email'              => (string)Tools::getValue('receiver_email'),
            'S_company'            => (string)Tools::getValue('sender_name'),
            'S_address1'           => (string)Tools::getValue('sender_addressLine1'),
            'S_address2'           => (string)Tools::getValue('sender_addressLine2'),
            'S_postcode'           => (string)Tools::getValue('sender_postalCode'),
            'S_city'               => (string)Tools::getValue('sender_city'),
            'S_country'            => (string)Tools::getValue('sender_countryID'),
            'S_contactname'        => (string)Tools::getValue('sender_contactName'),
            'S_phone'              => (string)Tools::getValue('sender_phone'),
            'S_email'              => (string)Tools::getValue('sender_email'),
            'S_account'            => (string)Tools::getValue('sender_account'),
            'SHOP_cost'            => $order->total_paid,
            'DEF_contents'         => (string)Tools::getValue('contents'),
            'RefNum'               => (string)Tools::getValue('referenceNumber'),
            'DEF_serviceCode'      => Configuration::get('apaczka_serviceCode'),
            'DEF_orderPickupType'  => (string)Tools::getValue('orderPickupType'),
            'DEF_insurance'        => (string)Tools::getValue('insurance'),
            'DEF_weight'           => (float)Tools::getValue('shipments_weight'),
            'DEF_dim1'             => (float)Tools::getValue('shipments_dim1'),
            'DEF_dim2'             => (float)Tools::getValue('shipments_dim2'),
            'DEF_dim3'             => (float)Tools::getValue('shipments_dim3'),
            'DEF_numOdPacks'       => (string)Tools::getValue('packageCount'),
            'S_DEF_notifDelivered' => (Tools::getValue('cbo12')),
            //(Configuration::get('apaczka_sender_notif_delivered')),
            'S_DEF_notifException' => (Tools::getValue('cbo22')),
            //(Configuration::get('apaczka_sender_notif_exception')),
            'S_DEF_notifRegister'  => (Tools::getValue('cbo32')),
            //(Configuration::get('apaczka_sender_notif_register')),
            'S_DEF_notifSent'      => (Tools::getValue('cbo42')),
            //(Configuration::get('apaczka_sender_notif_sent')),
            'R_DEF_notifDelivered' => (Tools::getValue('cbo11')),
            //(Configuration::get('apaczka_receiver_notif_delivered')),
            'R_DEF_notifException' => (Tools::getValue('cbo21')),
            //(Configuration::get('apaczka_receiver_notif_exception')),
            'R_DEF_notifRegister'  => (Tools::getValue('cbo31')),
            //(Configuration::get('apaczka_receiver_notif_register')),
            'R_DEF_notifSent'      => (Tools::getValue('cbo41')),
            //(Configuration::get('apaczka_receiver_notif_sent'))
        ));
    }

//******************************************************************************  

    /**
     * Prepares Smarty variables for displaying the form (Fields retrieved from the presty order and from the configuration data)
     * In addition, it downloads an address book and a list of countries, checks whether a download service has been selected
     *
     * @param type $params - order information
     */
    public function smartyAssignOrderForm($params)
    {
        $order = new Order((int)$params['id_order']);             //[cart][id_customer]

        $address = new Address((int)$params['cart']->id_address_delivery);

        $customer = new Customer((int)$params['cart']->id_customer);

        $sql    = 'SELECT * FROM apaczka_address_book';
        $result = Db::getInstance()->executeS($sql);

        $sql      = 'SELECT iso_code FROM ' . _DB_PREFIX_ . 'country WHERE id_country = ' . (int)$address->id_country;
        $res      = Db::getInstance()->executeS($sql);
        $iso_code = $res[0]['iso_code'];


        $cod = $order->module === 'ps_cashondelivery' ? 1
            : 0; //It reads from the order whether the cash on delivery option was selected

        //Countries list.

        $countries = json_decode((string)Configuration::get('countries'));


        $phone = $address->phone;


        $this->context->smarty->assign(array(//ORDER FOR SENDING ORDERS
            'countries'            => $countries,
            'contacts'             => $result,
            'cod'                  => $cod,
            'id_order'             => $params['id_order'], //$order->id_cart,
            'token'                => Tools::getValue('token'),
            'R_company'            => $address->company,
            'R_address1'           => $address->address1,
            'R_address2'           => $address->address2,
            'R_postcode'           => $address->postcode,
            'R_city'               => $address->city,
            'R_country'            => $iso_code ? $iso_code : '',
            'R_firstname'          => $address->firstname,
            'R_lastname'           => $address->lastname,
            'R_phone'              => $phone,
            'R_email'              => $customer->email,
            'S_company'            => Configuration::get('apaczka_sender_shop_name'),
            'S_address1'           => Configuration::get('apaczka_sender_address1'),
            'S_address2'           => Configuration::get('apaczka_sender_address2'),
            'S_postcode'           => Configuration::get('apaczka_sender_postcode'),
            'S_city'               => Configuration::get('apaczka_sender_city'),
            'S_country'            => Configuration::get('apaczka_sender_country'),
            'S_contactname'        => Configuration::get('apaczka_sender_contactName'),
            'S_phone'              => Configuration::get('apaczka_sender_phone'),
            'S_email'              => Configuration::get('apaczka_sender_email'),
            'S_account'            => Configuration::get('apaczka_account'),
            'SHOP_cost'            => $order->total_paid,
            'DEF_contents'         => Configuration::get('apaczka_contents'),
            'RefNum'               => Configuration::get('apaczka_ref_text'),
            'DEF_insurance'        => Configuration::get('apaczka_insurance'),
            'DEF_orderPickupType'  => Configuration::get('apaczka_orderPickupType'),
            'DEF_serviceCode'      => Configuration::get('apaczka_serviceCode'),
            'DEF_weight'           => Configuration::get('apaczka_weight'),
            'DEF_dim1'             => Configuration::get('apaczka_dimension1'),
            'DEF_dim2'             => Configuration::get('apaczka_dimension2'),
            'DEF_dim3'             => Configuration::get('apaczka_dimension3'),
            'DEF_numOdPacks'       => 1,
            'S_DEF_notifDelivered' => Configuration::get('apaczka_sender_notif_delivered'),
            'S_DEF_notifException' => Configuration::get('apaczka_sender_notif_exception'),
            'S_DEF_notifRegister'  => Configuration::get('apaczka_sender_notif_register'),
            'S_DEF_notifSent'      => Configuration::get('apaczka_sender_notif_sent'),
            'R_DEF_notifDelivered' => Configuration::get('apaczka_receiver_notif_delivered'),
            'R_DEF_notifException' => Configuration::get('apaczka_receiver_notif_exception'),
            'R_DEF_notifRegister'  => Configuration::get('apaczka_receiver_notif_register'),
            'R_DEF_notifSent'      => Configuration::get('apaczka_receiver_notif_sent')
        ));
    }

//******************************************************************************  

    /**
     * The function retrieves the sending data from the form and saves it to the address book. If such data already exists it does not duplicate them.
     */
    public function addToContacts()
    {
        $name        = pSQL((string)Tools::getValue('sender_name'));
        $addresLine1 = pSQL((string)Tools::getValue('sender_addressLine1'));
        $addresLine2 = pSQL((string)Tools::getValue('sender_addressLine2'));
        $postalCode  = pSQL((string)Tools::getValue('sender_postalCode'));
        $city        = pSQL((string)Tools::getValue('sender_city'));
        $countryID   = pSQL('0');
        $contactName = pSQL((string)Tools::getValue('sender_contactName'));
        $phone       = pSQL((string)Tools::getValue('sender_phone'));
        $email       = pSQL((string)Tools::getValue('sender_email'));
        $account     = pSQL((string)Tools::getValue('sender_account'));

        $sql
            = "INSERT IGNORE INTO `apaczka_address_book` (`nazwa`,`adres`, `adres2`, `kod_pocztowy`,
                `miasto`,`osoba_kontaktowa`, `id_kraju`,`telefon`, `email`, `konto_pobraniowe` ) 
                VALUES ('$name','$addresLine1','$addresLine2','$postalCode','$city', '$contactName', $countryID, '$phone', '$email','$account');";
        Db::getInstance()->execute($sql);
    }

//******************************************************************************

    /**
     * Downloading a consignment note from API Apaczka.pl.
     * First, you will know the order number from Presty from the 'apaczka_orders' table and order_medium ID, and on the basis of this, we collect the transport document.
     */
    public function sendWaybill()
    {
        if (Tools::getValue('id_order') != null && Tools::getValue('id_order') != '') {
            $sql         = 'SELECT id_order_apaczka FROM apaczka_orders WHERE id_order_presta = '
                           . (int)Tools::getValue('id_order');
            $result      = Db::getInstance()->executeS($sql);
            $isOrderSent = (int)($result[0]['id_order_apaczka']);
        } else {
            print_r("PUSTY id_order", 1);
        }

        $apaczka = new apaczkaApi((string)Configuration::get('apaczka_login'),
            (string)Configuration::get('apaczka_password'), (string)Configuration::get('apaczka_apikey'));
        if ((Configuration::get('apaczka_test'))) {
            $apaczka->setTestMode();
        } else {
            $apaczka->setProductionMode();
        }
        ob_end_clean();     //bez tego sa problemy przy otwieraniu PDFa (smieci z bufora)
        $result      = $apaczka->getWaybillDocument($isOrderSent);
        $pdf_decoded = $result->return->waybillDocument;
        $name        = 'ApaczkaWayBill' . Tools::getValue('id_order') . '.pdf';
        header('Pragma: public');
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Cache-Control: private', false);
        header('Content-Description: File Transfer');
        header('Content-Type: application/pdf');
        header('Content-Type: application/octet-stream');
        header('Content-Type: application/download');
        header('Content-Disposition: attachment; filename=' . $name);

        header('Connection: close');
        die($pdf_decoded);
    }

    //******************************************************************************
    /**
     * The function downloads from the DisplayAdminOrder.tpl form all fields necessary to send orders and wraps them into the ApaczkaOrder class, which returns.
     *
     * @return \ApaczkaOrder
     */
    //kex_default_accounts
    public function prepareOrderToApi()
    {

        $order_apacz = new ApaczkaOrder();

        $order_apacz->notificationDelivered = $order_apacz->createNotification((Tools::getValue('cbo11')), false,
            (Tools::getValue('cbo12')), false);
        $order_apacz->notificationException = $order_apacz->createNotification((Tools::getValue('cbo21')), false,
            (Tools::getValue('cbo22')), false);
        $order_apacz->notificationNew       = $order_apacz->createNotification((Tools::getValue('cbo31')), false,
            (Tools::getValue('cbo32')), false);
        $order_apacz->notificationSent      = $order_apacz->createNotification((Tools::getValue('cbo41')), false,
            (Tools::getValue('cbo42')), false);

        $order_apacz->setServiceCode((string)Tools::getValue('serviceCode'));
        $order_apacz->referenceNumber = (string)Tools::getValue('referenceNumber');
        $order_apacz->isDomestic      = (((string)Tools::getValue('sender_countryID') == '0')
                                         && ((string)Tools::getValue('receiver_countryId') == '0')) ? true : false;
        $order_apacz->contents        = (string)Tools::getValue('contents');

        $order_apacz->setSenderAddress((string)Tools::getValue('sender_name'),
            (string)Tools::getValue('sender_contactName'), (string)Tools::getValue('sender_addressLine1'),
            (string)Tools::getValue('sender_addressLine2'), (string)Tools::getValue('sender_city'),
            (string)Tools::getValue('sender_countryID'), (string)Tools::getValue('sender_postalCode'), '',
            (string)Tools::getValue('sender_email'), (string)Tools::getValue('sender_phone'));
        $order_apacz->setReceiverAddress((string)Tools::getValue('receiver_name'),
            (string)Tools::getValue('receiver_contactName'), (string)Tools::getValue('receiver_addressLine1'),
            (string)Tools::getValue('receiver_addressLine2'), (string)Tools::getValue('receiver_city'),
            (string)Tools::getValue('receiver_countryId'), (string)Tools::getValue('receiver_postalCode'), '',
            (string)Tools::getValue('receiver_email'), (string)Tools::getValue('receiver_phone'));
        //***************   Cash On Delivery           ********
        if ((string)Tools::getValue('cod') == '1') {
            $order_apacz->setPobranie((string)Tools::getValue('sender_account'),
                (float)(100 * Tools::getValue('codAmount')));
        }
        //***************   Parcel or documents?    ********
        if ((string)Tools::getValue('shipmentTypeCode') === 'PACZ') {
            $order_shipment = new ApaczkaOrderShipment((string)Tools::getValue('shipmentTypeCode'),
                (float)Tools::getValue('shipments_dim1'), (float)Tools::getValue('shipments_dim2'),
                (float)Tools::getValue('shipments_dim3'), (float)Tools::getValue('shipments_weight'));
        } else {
            $order_shipment = new ApaczkaOrderShipment((string)Tools::getValue('shipmentTypeCode'), (float)(10),
                (float)(10), (float)(10), (float)(1));
        }
        //***************   Insurance      ********
        if ((string)Tools::getValue('insurance') == '1') {
            $order_shipment->setShipmentValue((float)(100 * Tools::getValue('shipments_shipmentValue')));
        }
        //***************   Non typical parcel? (checkbox noStd checked)      ********
        if (Tools::getValue('noStd') != 0 && (string)Tools::getValue('shipmentTypeCode') === 'PACZ') {
            $order_shipment->addOrderOption('PRZES_NIETYP');
        }
        if (Tools::getValue('bigPack') != 0 && (string)Tools::getValue('shipmentTypeCode') === 'PACZ') {
            $order_shipment->addOrderOption('DUZA_PACZKA');
        }
        $ilePaczek = (int)Tools::getValue('packageCount');
        if (! ($ilePaczek >= 1 && $ilePaczek <= 20)) {
            $ilePaczek = 1;
        }
        for ($i = 0; $i < $ilePaczek; $i++) {
            $order_apacz->addShipment($order_shipment);
        }
        //$order_apacz->addShipment($order_shipment);
        $order_apacz->setPickup((string)Tools::getValue('orderPickupType'), (string)Tools::getValue('pickupTimeFrom'),
            (string)Tools::getValue('pickupTimeTo'), (string)Tools::getValue('pickupDate'));

        return $order_apacz;
    }

//******************************************************************************  

    /**
     * Prepares smarty variables for the AdminOrderSent.tpl form (displayed when the shipping order was successful)
     *
     * @param type $order - order data
     */
    public function assignSmartyToSendedOrder($id_order)
    {

        $sql        = 'SELECT order_number_apaczka FROM apaczka_orders WHERE id_order_presta = "' . (int)$id_order
                      . '"';
        $id_apaczka = Db::getInstance()->executeS($sql);
        $this->context->smarty->assign(array(
            'id_order'             => $id_order,
            'order_number_apaczka' => $id_apaczka[0]["order_number_apaczka"],
            'token'                => Tools::getValue('token'),
            'isTest'               => (Configuration::get('apaczka_test'))
        ));
    }

    //******************************************************************************

    /**
     * The function checks whether this order was already sent by Apaczka.pl or not. Id_order is taken from the $ _GET variable.
     * Thanks to the isThisOrderSent sliding, the hookdisplayAdminOrder function checks whether it displays the shipping form or only the information about the already sent parcel.
     *
     * @return true or false. True when the order was sent
     */
    public function isThisOrderSent()
    {
        $isOrderSent = 0;               //Needed to determine if the order has already been sent or not
        if (Tools::getValue('id_order') != null && Tools::getValue('id_order') != '') {
            $sql         = 'SELECT COUNT(*) FROM apaczka_orders WHERE id_order_presta = '
                           . (int)Tools::getValue('id_order');
            $result      = Db::getInstance()->executeS($sql);
            $isOrderSent = (int)($result[0]['COUNT(*)']);
        }

        return ($isOrderSent == 0) ? false : true;
    }

//****************************************************************************** 

    /**
     * The function checks whether the given Login, Password and apikey are correct.
     *
     * @return true lub false.
     */
    public function validateAuth()
    {
        $apaczka = new apaczkaApi((string)Configuration::get('apaczka_login'),
            (string)Configuration::get('apaczka_password'), (string)Configuration::get('apaczka_apikey'));
        if ((Configuration::get('apaczka_test'))) {
            $apaczka->setTestMode();
        } else {
            $apaczka->setProductionMode();
        }

        $resp = $apaczka->validateAuthData();

        return $resp->return->isValid ? true : false;
    }

//****************************************************************************** 

    /**
     * The function is called when in the 'Orders' menu, we enter the form for sending orders and we are going to press them with the button 'send from apaczka'.
     * The function of this function is to check the connection with Apaczka.pl and if it is possible to send data through the API.
     * In case of failure, prepares messages to display to the user.
     *
     * @return container with 'status' and 'out'
     * status - the variable accepts the value:
     * 0 when the data passes the pre-validation and is sent correctly.
     * 1 when login, password or API key are incorrect.
     * 2 when there is an error when sending (data error or SOAP fault.
     * out - text description of the error in the case of status different from 0, if not this ''
     */
    public function prepareAndSendOrder()
    {
        $ret = 0;
        $out = '';

        if (! $this->validateAuth()) {      //are the login and password for the API correct?
            $ret = 1;
            $out = 'Login Error. Are the login, password or API key correct?';
        } else {
            $apaczka = new apaczkaApi((string)Configuration::get('apaczka_login'),
                (string)Configuration::get('apaczka_password'), (string)Configuration::get('apaczka_apikey'));
            if ((Configuration::get('apaczka_test'))) {
                $apaczka->setTestMode();
            } else {
                $apaczka->setProductionMode();
            }


            $order_apacz = $this->prepareOrderToApi();      //PACKAGING ORDER IN CLASS ORDER (READY TO API)

            $resp = $apaczka->placeOrder($order_apacz); //If it worked

            if ($resp !== false && $resp->return->order) {  //Send to API
                $orderIdApaczka     = pSQL($resp->return->order->id); //We managed to send to apaczka.pl service
                $orderNumberApaczka = pSQL($resp->return->order->orderNumber);
                $orderIdPresta      = pSQL(Tools::getValue('id_order'));


                $sql
                    = "INSERT IGNORE INTO `apaczka_orders` (`id_order_presta`,`id_order_apaczka`, `order_number_apaczka`) 
                            VALUES ('$orderIdPresta','$orderIdApaczka','$orderNumberApaczka');";
                Db::getInstance()->execute($sql);
            } else {        //If you did not manage to place an order through API apaczka.pl - incorrect data or other problem
                $ret = 2;
                $out = 'It was not possible to place an order at apaczka.pl. SOAP Error'
                       . print_r($resp->return->result->messages->Message->description, 1);
            }
        }

        return array(
            "status" => $ret,
            "out"    => $out,
        );
    }

//******************************************************************************  

    /**
     * The function called by Preste when entering the Ordrs tab and selecting one of the orders.
     * Depending on whether the order was already sent /// it was not sent or it could not be sent
     * the displayAdminOrderSent.tpl /// displayAdminOrder.tpl form is displayed correctly.
     * If the order was sent correctly and
     *
     * @param type $params
     *
     * @return type
     */
    public function hookdisplayAdminOrder($params)
    {
        //The function called by presta when clicking on the tab orders-> choosing_mark
        $output = '';
        $order  = new Order((int)$params['id_order']);                      //our presta order
        //$address = new Address((int) $params['cart']->id_address_delivery); //shipping address (from presta)
        //$customer = new Customer((int) $params['cart']->id_customer);       //customer data (from presta)
        //file_put_contents('XOLTResult.log', "[" . date('c') . "]\n" . "----------hookDisplayAdminOrder link:\n" . print_r($_GET, 1) . " \n", FILE_APPEND);

        if (Tools::isSubmit('sendwaybill')) {               //If we clicked the button to send the order
            $this->sendWaybill();

            return $this->display(__FILE__, 'views/templates/hook/displayAdminOrderSent.tpl');
        } elseif (Tools::isSubmit('sendsubmit')) {             //If we clicked the "Send with Apaczka" button
            $result
                = $this->prepareAndSendOrder();    //calling function to send order (with validation and error handling)
            if (! $result['status']) {
                $this->assignSmartyToSendedOrder($params['id_order']);   //Preparation of smarty variables for the new shipping form

                return $this->display(__FILE__,
                    'views/templates/hook/displayAdminOrderSent.tpl');  //displaying the shipping form
            } else {
                $this->smartyAssignOrderFormError($params);     //Preparing smarty variables for a form that needs to be corrected
                $output = $this->displayError($this->l($result['out'])
                                              . '(*)Remember to set the collection times again and the type of shipment.');  //displaying information about where it was wrong

                return $output . $this->display(__FILE__, 'views/templates/hook/displayAdminOrder.tpl');
            }
        } elseif ($this->isThisOrderSent()) {                    //If we enter an already sent order
            $this->assignSmartyToSendedOrder($params['id_order']);   //Preparation of smarty variables to the displayAdminOrderSent.tpl form

            return $this->display(__FILE__, 'views/templates/hook/displayAdminOrderSent.tpl');
        } else {
            if (Tools::isSubmit('addContact')) {    //If you clicked 'add to address book' button
                $this->addToContacts();
            }//Displaying the form for shipping
            $this->smartyAssignOrderForm($params);
            if (! $this->validateAuth()) {
                $output
                    = $this->displayError($this->l('The module is not configured correctly. Please go to the Modules-> ApaczkaShipping-> configure tab and complete the required fields.'));
            }

            return $output . $this->display(__FILE__, 'views/templates/hook/displayAdminOrder.tpl');
        }
    }

//******************************************************************************

    /**
     * The function called by presta when entering the Modules tab and then selecting the Buttons 'Configure'.
     * The purpose of the function is to support the complex configuration form and save the correct data to the configuration variables.
     * Additionally, it tests the connection with the Apaczka.pl server
     *
     * @return form to display by displayForm functions and information about validity or not data and whether it was possible to connect to the server.
     */
    public function getContent()
    {
        $output = '';
        if (Tools::isSubmit('submit' . $this->name)) {
            $name_API           = (string)Tools::getValue('ApaczkaNameAPI');
            $passwd_API         = (string)Tools::getValue('ApaczkaPasswordAPI');
            $key_API            = (string)Tools::getValue('ApaczkaKeyAPI');
            $test_API           = (Tools::getValue('ApaczkaIsTest'));
            $shopName           = (string)Tools::getValue('ApaczkaSenderName');
            $shopAddr1          = (string)Tools::getValue('ApaczkaSenderAddress1');
            $shopAddr2          = (string)Tools::getValue('ApaczkaSenderAddress2');
            $shopPostCode       = (string)Tools::getValue('ApaczkaSenderPostalCode');
            $shopCity           = (string)Tools::getValue('ApaczkaSenderCity');
            $shopCountry        = (string)Tools::getValue('ApaczkaSenderCountry');
            $shopContact        = (string)Tools::getValue('ApaczkaSenderContactName');
            $shopPhone          = (string)Tools::getValue('ApaczkaSenderPhone');
            $shopEmail          = (string)Tools::getValue('ApaczkaSenderEmail');
            $shopAccount        = (string)Tools::getValue('ApaczkaSenderAccount');
            $shopRefText        = (string)Tools::getValue('ApaczkaRefText');
            $shopPackContent    = (string)Tools::getValue('ApaczkaContent');
            $shopPackWeight     = (int)Tools::getValue('ApaczkaWeight');
            $shopPackDim1       = (string)Tools::getValue('ApaczkaDim1');
            $shopPackDim2       = (string)Tools::getValue('ApaczkaDim2');
            $shopPackDim3       = (string)Tools::getValue('ApaczkaDim3');
            $notifSendDel       = (string)Tools::getValue('ApaczkaSenderDelivered');
            $notifSendExc       = (string)Tools::getValue('ApaczkaSenderException');
            $notifSendReg       = (string)Tools::getValue('ApaczkaSenderRegister');
            $notifSendSent      = (string)Tools::getValue('ApaczkaSenderSent');
            $notifRecDel        = (string)Tools::getValue('ApaczkaReceiverDelivered');
            $notifRecExc        = (string)Tools::getValue('ApaczkaReceiverException');
            $notifRecReg        = (string)Tools::getValue('ApaczkaReceiverRegister');
            $notifRecSent       = (string)Tools::getValue('ApaczkaReceiverSent');
            $defInsurance       = (string)Tools::getValue('ApaczkaInsurance');
            $defOrderPickupType = (string)Tools::getValue('ApaczkaOrderPickupType');
            $defServiceCode     = (string)Tools::getValue('ApaczkaServiceCode');
            //Checking whether the Login, Password, KeyAPI are correct
            $apaczka = new apaczkaApi($name_API, $passwd_API, $key_API);
            if ($test_API) {
                $apaczka->setTestMode();
            } else {
                $apaczka->setProductionMode();
            }
            $resp = $apaczka->validateAuthData();

            if (! ($resp->return->isValid)) {    //if the login details are ok, we write to the configuration variables
                $output .= $this->displayError($this->l('Unable to connect to the server. Validate login, password, keyAPI and server selection (test / not)'));
            } else {
                Configuration::updateValue('apaczka_login', $name_API);
                Configuration::updateValue('apaczka_password', $passwd_API);
                Configuration::updateValue('apaczka_apikey', $key_API);
                Configuration::updateValue('apaczka_test', (($test_API)));
            }                       //if I store a good store block then we save it
            if (! $shopName || empty($shopName) || ! $shopAddr1 || empty($shopAddr1) || ! $shopPostCode
                || empty($shopPostCode)
                || ! $shopCity
                || empty($shopCity)
            ) {
                $output .= $this->displayError($this->l('The senders data has not been completed!'));
            } else {
                Configuration::updateValue('apaczka_sender_shop_name', $shopName);
                Configuration::updateValue('apaczka_sender_address1', $shopAddr1);
                Configuration::updateValue('apaczka_sender_address2', $shopAddr2);
                Configuration::updateValue('apaczka_sender_postcode', $shopPostCode);
                Configuration::updateValue('apaczka_sender_city', $shopCity);
            }                       //if the second block of store data is good, we save it
            if (! $shopContact || empty($shopContact) || ! $shopPhone || empty($shopPhone) || ! $shopEmail
                || empty($shopEmail)
                || ! $shopAccount
                || empty($shopAccount)
            ) {
                $output .= $this->displayError($this->l('The senders data has not been completed!'));
            } else {
                Configuration::updateValue('apaczka_sender_contactName', $shopContact);
                Configuration::updateValue('apaczka_sender_phone', $shopPhone);
                Configuration::updateValue('apaczka_sender_email', $shopEmail);
                Configuration::updateValue('apaczka_account', $shopAccount);
            }                       //if the 3rd block of store data is good, we save it
            if (empty($shopPackContent) || ! $shopPackWeight > 0 || empty($shopPackWeight) || ! $shopPackDim1 > 0
                || empty($shopPackDim1)
                || ! $shopPackDim2 > 0
                || empty($shopPackDim2)
                || ! $shopPackDim3 > 0
                || empty($shopPackDim3)
            ) {
                $output .= $this->displayError($this->l('Paragraphs not complied with default packages and invoices!'));
            } else {
                Configuration::updateValue('apaczka_ref_text', $shopRefText);
                Configuration::updateValue('apaczka_contents', $shopPackContent);
                Configuration::updateValue('apaczka_weight', $shopPackWeight);
                Configuration::updateValue('apaczka_dimension1', $shopPackDim1);
                Configuration::updateValue('apaczka_dimension2', $shopPackDim2);
                Configuration::updateValue('apaczka_dimension3', $shopPackDim3);
            }                       //if the country exists, we save it (without the credentials entered, the country list is not displayed
            if ($shopCountry == '') {
                $output .= $this->displayError($this->l('The country name has not been completed, please choose one from the list (you will need a login, password and api key to display the list of countries)'));
            } else {
                Configuration::updateValue('apaczka_sender_country', $shopCountry);
            }
            Configuration::updateValue('apaczka_sender_notif_delivered', $notifSendDel);
            Configuration::updateValue('apaczka_sender_notif_exception', $notifSendExc);
            Configuration::updateValue('apaczka_sender_notif_register', $notifSendReg);
            Configuration::updateValue('apaczka_sender_notif_sent', $notifSendSent);
            Configuration::updateValue('apaczka_receiver_notif_delivered', $notifRecDel);
            Configuration::updateValue('apaczka_receiver_notif_exception', $notifRecExc);
            Configuration::updateValue('apaczka_receiver_notif_register', $notifRecReg);
            Configuration::updateValue('apaczka_receiver_notif_sent', $notifRecSent);

            Configuration::updateValue('apaczka_insurance', $defInsurance);
            Configuration::updateValue('apaczka_orderPickupType', $defOrderPickupType);
            Configuration::updateValue('apaczka_serviceCode', $defServiceCode);


            if ($output == '') {
                $output .= $this->displayConfirmation($this->l('Settings saved!'));
                //******************** IF YOU CONFIGURED THEY ARE SAYING TO LINK TO VARIABLE CONFIGURATION LIST OF COUNTRIES (not to download it all the time)
                $apaczka = new apaczkaApi($name_API, $passwd_API, $key_API);
                if ((Configuration::get('apaczka_test'))) {
                    $apaczka->setTestMode();
                } else {
                    $apaczka->setProductionMode();
                }
                $resp  = $apaczka->getCountries();
                $count = $resp->return->countries->Country;
                //************* COUNTRIES *****************
                Configuration::updateValue('countries', json_encode($count));
            }
        }

        return $output . $this->displayForm();
    }

//******************************************************************************

    /**
     * Prepares smart variables for displaying the configuration form,
     * then it includes the file views / helperFormViewConfig.php saved in a way understood by the helper presty, which generates the form.
     *
     * @return displayed form.
     */
    public function displayForm()
    {
        $default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

        $apaczka = new apaczkaApi((string)Configuration::get('apaczka_login'),
            (string)Configuration::get('apaczka_password'), (string)Configuration::get('apaczka_apikey'));
        if ((Configuration::get('apaczka_test'))) {
            $apaczka->setTestMode();
        } else {
            $apaczka->setProductionMode();
        }
        $resp = $apaczka->getCountries();
        if (isset($resp->return->countries->Country)) {
            $countries
                = $resp->return->countries->Country;        //THIS IS USED IN views / helperFormViewConfig.php !!!
        } else {
            $countries = array(
                array(                            //THIS IS USED IN views / helperFormViewConfig.php !!!
                    "code" => "PL",
                    "id"   => 0,
                    "name" => "Polska"
                )
            );
        }

        include('views/helperFormViewConfig.php');


        $helper = new HelperForm();

        // Module, token and currentIndex
        $helper->module          = $this;
        $helper->name_controller = $this->name;
        $helper->token           = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex    = AdminController::$currentIndex . '&configure=' . $this->name;

        // Language
        $helper->default_form_language    = $default_lang;
        $helper->allow_employee_form_lang = $default_lang;

        // Title and toolbar
        $helper->title          = $this->displayName;
        $helper->show_toolbar   = true;
        $helper->toolbar_scroll = true;      // yes - > Toolbar is always visible on the top of the screen.
        $helper->submit_action  = 'submit' . $this->name;

        // Load current value
        $helper->fields_value['ApaczkaNameAPI']     = Configuration::get('apaczka_login');
        $helper->fields_value['ApaczkaPasswordAPI'] = Configuration::get('apaczka_password');
        $helper->fields_value['ApaczkaKeyAPI']      = Configuration::get('apaczka_apikey');
        $helper->fields_value['ApaczkaIsTest']      = Configuration::get('apaczka_test');
        //********************
        $helper->fields_value['ApaczkaSenderName']        = Configuration::get('apaczka_sender_shop_name');
        $helper->fields_value['ApaczkaSenderAddress1']    = Configuration::get('apaczka_sender_address1');
        $helper->fields_value['ApaczkaSenderAddress2']    = Configuration::get('apaczka_sender_address2');
        $helper->fields_value['ApaczkaSenderPostalCode']  = Configuration::get('apaczka_sender_postcode');
        $helper->fields_value['ApaczkaSenderCity']        = Configuration::get('apaczka_sender_city');
        $helper->fields_value['ApaczkaSenderCountry']     = Configuration::get('apaczka_sender_country');
        $helper->fields_value['ApaczkaSenderContactName'] = Configuration::get('apaczka_sender_contactName');
        $helper->fields_value['ApaczkaSenderPhone']       = Configuration::get('apaczka_sender_phone');
        $helper->fields_value['ApaczkaSenderEmail']       = Configuration::get('apaczka_sender_email');
        $helper->fields_value['ApaczkaSenderAccount']     = Configuration::get('apaczka_account');
        //********************
        $helper->fields_value['ApaczkaContent'] = Configuration::get('apaczka_contents');
        $helper->fields_value['ApaczkaRefText'] = Configuration::get('apaczka_ref_text');
        $helper->fields_value['ApaczkaWeight']  = Configuration::get('apaczka_weight');
        $helper->fields_value['ApaczkaDim1']    = Configuration::get('apaczka_dimension1');
        $helper->fields_value['ApaczkaDim2']    = Configuration::get('apaczka_dimension2');
        $helper->fields_value['ApaczkaDim3']    = Configuration::get('apaczka_dimension3');
        //********************
        $helper->fields_value['ApaczkaSenderDelivered']   = Configuration::get('apaczka_sender_notif_delivered');
        $helper->fields_value['ApaczkaSenderException']   = Configuration::get('apaczka_sender_notif_exception');
        $helper->fields_value['ApaczkaSenderRegister']    = Configuration::get('apaczka_sender_notif_register');
        $helper->fields_value['ApaczkaSenderSent']        = Configuration::get('apaczka_sender_notif_sent');
        $helper->fields_value['ApaczkaReceiverDelivered'] = Configuration::get('apaczka_receiver_notif_delivered');
        $helper->fields_value['ApaczkaReceiverException'] = Configuration::get('apaczka_receiver_notif_exception');
        $helper->fields_value['ApaczkaReceiverRegister']  = Configuration::get('apaczka_receiver_notif_register');
        $helper->fields_value['ApaczkaReceiverSent']      = Configuration::get('apaczka_receiver_notif_sent');


        $helper->fields_value['ApaczkaInsurance']       = Configuration::get('apaczka_insurance');
        $helper->fields_value['ApaczkaOrderPickupType'] = Configuration::get('apaczka_orderPickupType');
        $helper->fields_value['ApaczkaServiceCode']     = Configuration::get('apaczka_serviceCode');

        return $helper->generateForm($fields_form); //$fields_form initiated in views/helperFormViewConfig.php !!!
    }
}
