{**
 * 2007-2019 PrestaShop and Contributors
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2019 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
<div id="_desktop_cart" class="d-inline-block">
  <div class="dropdown js-dropdown">
    <div class="blockcart cart-preview {if $cart.products_count > 0}active{else}inactive{/if}" data-refresh-url="{$refresh_url}">
      <div class="header">
       <!--  {if $cart.products_count > 0}
          <a rel="nofollow" href="{$cart_url}">
        {/if} -->
        <div class="d-inline-block cart-top-b" data-toggle="dropdown">
          <span class="cart-img"></span>
          <div class="cartco"><span class="hidden-sm-down">{l s='Koszyk' d='Shop.Theme.Checkout'}</span><br class="hidden-sm-down"><span id="cart-total"><span class="cartcount cart-products-count">{$cart.products_count}</span><span class="cartiva hidden-sm-down">{$cart.totals.total.value}</span></span></div>
        </div>
       <!--  {if $cart.products_count > 0}
          </a>
        {/if} -->
        <ul class="dropdown-menu dropdown-menu-right insp-cart-drop">
          {if $cart.products_count > 0}
            <div class="ht_cart cart-hover-content">
                <ul>

                            
                
                    {foreach from=$cart.products item=product}
                      <img class="" src="{$product.cover.bySize.cart_default.url}" alt="{$product.name|escape:'quotes'}">
                      <div>
                        <h3>
                          <a class="" href="{$product.url}" data-id_customization="{$product.id_customization|intval}">{$product.name}</a>
                        </h3>
                        <div>
                          {$product.quantity} X 
                           {if isset($product.is_gift) && $product.is_gift}
                              <span>{l s='Gift' d='Shop.Theme.Checkout'}</span>
                          {else}
                              <span>{$product.total}</span>
                          {/if}
                        </div>
                        <div>
                          <a class = "remove-from-cart" rel = "nofollow" href = "{$product.remove_from_cart_url}" data-link-action = "delete-from-cart" data-id-product  = "{$product.id_product|escape:'javascript'}" data-id-product-attribute = "{$product.id_product_attribute|escape:'javascript'}"data-id-customization = "{$product.id_customization|escape:'javascript'}">{if !isset($product.is_gift) || !$product.is_gift}<i class="material-icons float-xs-left">delete</i>{/if}</a>
                        </div>
                      </div>
                      <div class="clearfix"></div>
                      <hr>
                    {/foreach}
                </ul>
                
                <div class="cart-summary">
                    <div class="cart-subtotals">
                        {foreach from=$cart.subtotals item="subtotal"}
                            <div class="{$subtotal.type}">
                                <span class="label">{$subtotal.label}</span>
                                <span class="value">{$subtotal.value}</span>
                            </div>
                        {/foreach}
                    </div><hr>
                    <div class="cart-total">
                        <span class="label">{$cart.totals.total.label}</span>
                        <span class="value">{$cart.totals.total.value}</span>
                    </div>
                </div>
                <div class="cart-wishlist-action text-xs-center">
                    <a class="btn btn-primary" href="{$cart_url}">Pokaż koszyk</a>
                    <a class="btn btn-primary" href="{$urls.pages.order}">{l s='Kasa' d='Shop.Theme.Actions'}</a>
                </div>
            </div> 
        {else}
            <div class="ht_cart cart-hover-content">
                <p class="no-item">Brak przedmiotów w koszyku.</p>
            </div>
  {/if}
        </ul>
      </div>
    </div>
  </div>
</div>
